import java.sql.*;			/* Libreria utilizzata per interagire con la base di dati */
import java.io.File;			/* Libreria utilizzata per la scansione del file system */
import de.vdheide.mp3.*;		/* Libreria utilizzata per la lettura dei tag id3 */
import de.vdheide.utils.*;		/* Libreria utilizzata per la lettura dei tag id3 */
import java.net.InetAddress;		/* Libreria utilizzata per conoscere l'indirizzo ip e il nome dell'host */

public class Smp3 {

static Connection con = null;		/* variabile necessaria per la connessione al DBMS */
static String my_table = "mp3";		/* nome della tabella in cui inserire i dati */
static String nome_host=null;		/* nome dell'host */
static String ind_ip=null;		/* indirizzo ip dell'host */
static String ro=null;			/* variabile per la root di codivisione */

	public static void main(String[] args)
			{String url=null;			/* la directory da scansionare */
		         String serverName = "localhost";	/* nome del server in cui e' installato MySql */
		         String mydatabase = "daniele";		/* nome del database su cui lavorare */
		         String username = "rampoldi";		/* username da utilizzare per la connessione a MySql */
		         String password = "rampoldi";		/* password da utilizzare per la connessione a MySql */
			 InetAddress ip=null;			/* variabile in cui inserire l'indirizzo ip dell'host */
			 int cancella=0;			/* se cancella==1 --> elimina tutte le precedenti righe inserite da quell'host */

			 try
				{ip=java.net.InetAddress.getLocalHost();	/* public static InetAddress getLocalHost()
											throws UnknownHostException
												(Returns the local host) */
				 nome_host=ip.getHostName();	/* public String getHostName()
									(Gets the host name for this IP address) */
				 ind_ip=ip.getHostAddress();	/* public String getHostAddress()
									(Returns the IP address string in textual presentation) */
				}
			 catch(Exception ex)
				{System.out.println("Errore nel recupero dell'indirizzo ip");
				 nome_host="";
				 ind_ip="127.0.0.1";
				}

			 if(args.length!=0)		/* entra se nel chiamare l'applicazione ho utilizzato dei parametri aggiuntivi */
				{int p=0;		/* identifica il parametro i-esimo */
				 while(p < args.length)
					{if(args[p].equals("-s"))	/* indica il servername da cambiare */
						{p++;
						 try
							{serverName=args[p].substring(0);
							}
						 catch(Exception ex)
							{System.out.println("Errore di sintassi in input -s");
							 return;
							}
						 p++;
						 continue;
						}
					 if(args[p].equals("-u"))	/* indica l'username */
						{p++;
						 try
							{username=args[p].substring(0);
							}
						 catch(Exception ex)
							{System.out.println("Errore di sintassi in input -u");
							 return;
							}
						 p++;
						 continue;
						}
					 if(args[p].equals("-p"))	/* indica la password */
						{p++;
						 try
							{password=args[p].substring(0);
							}
						 catch(Exception ex)
							{System.out.println("Errore di sintassi in input -p");
							 return;
							}
						 p++;
						 continue;
						}
					 if(args[p].equals("-b"))	/* indica il database da cambiare */
						{p++;
						 try
							{mydatabase=args[p].substring(0);
							}
						 catch(Exception ex)
							{System.out.println("Errore di sintassi in input -b");
							 return;
							}
						 p++;
						 continue;
						}
					 if(args[p].equals("-d"))	/* indica la directory da scandire */
						{p++;
						 try
							{url=args[p].substring(0);
							}
						 catch(Exception ex)
							{System.out.println("Errore di sintassi in input -d");
							 return;
							}
						 while(p+1 < args.length)	/* in windows il nome di una cartella puo' contenere uno spazio (es.:"C:\Documents and Settings"): il nome viene dunque passato al programma in piu' parametri anziche' in uno solo */
							 {if(!(args[p+1].equals("-r")) && !(args[p+1].equals("-n")) && !(args[p+1].equals("-i")) && !(args[p+1].equals("-d")) && !(args[p+1].equals("-c")) && !(args[p+1].equals("-h")) && !(args[p+1].equals("-s")) && !(args[p+1].equals("-b")) && !(args[p+1].equals("-u")) && !(args[p+1].equals("-p")))
								{p++;
								 url=url+" "+args[p].substring(0);
								}
							  else
								break;
							 }
						 if(java.io.File.separator.equals(url.substring(url.length()-1)))
							url=url;	/* se la directory in input termina con il separatore non faccio niente (es.:"C:\") */
						 else
							url=url+java.io.File.separator;	/* se la directory in input non termina con il separatore lo aggiungo (es.:"C:" --> diventa --> "C:\") */
						 p++;
						 continue;
						}
					 if(args[p].equals("-r"))	/* indica la root di condivisione. Blocco di codice analogo al precedente */
						{p++;
						 try
							{ro=args[p].substring(0);
							}
						 catch(Exception ex)
							{System.out.println("Errore di sintassi in input -r");
							 return;
							}
						 while(p+1 < args.length)
							 {if(!(args[p+1].equals("-r")) && !(args[p+1].equals("-n")) && !(args[p+1].equals("-i")) && !(args[p+1].equals("-d")) && !(args[p+1].equals("-c")) && !(args[p+1].equals("-h")) && !(args[p+1].equals("-s")) && !(args[p+1].equals("-b")) && !(args[p+1].equals("-u")) && !(args[p+1].equals("-p")))
								{p++;
								 ro=ro+" "+args[p].substring(0);
								}
							  else
								break;
							 }
						 if(java.io.File.separator.equals(ro.substring(ro.length()-1)))
							ro=ro;
						 else
							ro=ro+java.io.File.separator;
						 p++;
						 continue;
						}
					 if(args[p].equals("-c"))	/* cancella tutte le righe della BDD riferite all'host corrente */
						{cancella=1;
						 p++;
						 continue;
						}
					 if(args[p].equals("-i"))	/* nuovo indirizzo ip */
						{p++;
						 try
							{ind_ip=args[p].substring(0);
							}
						 catch(Exception ex)
							{System.out.println("Errore di sintassi in input -i");
							 return;
							}
						 p++;
						 continue;
						}
					 if(args[p].equals("-n"))	/* nuovo nome host */
						{p++;
						 try
							{nome_host=args[p].substring(0);
							}
						 catch(Exception ex)
							{System.out.println("Errore di sintassi in input -n");
							 return;
							}
						 p++;
						 continue;
						}
					 if(args[p].equals("-h"))	/* help --> stampa a video i possibili parametri */
						{System.out.println();
						 System.out.println("Parametri disponibili:");
						 System.out.println(" -h --> help");
						 System.out.println(" -s --> server su cui sono presenti i databases");
						 System.out.println("       es.:  \"-s db.stat.unipd.it\"");
						 System.out.println(" -b --> nome del database");
						 System.out.println("       es.:  \"-b daniele\"");
						 System.out.println(" -u --> username");
						 System.out.println("       es.:  \"-u rampoldi\"");
						 System.out.println(" -p --> password");
						 System.out.println("       es.:  \"-p rampoldi\"");
						 System.out.println(" -i --> ip");
						 System.out.println("       es.:  \"-i 127.0.0.99\"");
						 System.out.println(" -n --> nome dell'host");
						 System.out.println("       es.:  \"-n DR_casa\"");
						 System.out.println(" -r --> root di condivisione");
						 System.out.println("       es.:  \"-r c:\\www\"");
						 System.out.println(" -c --> cancella dal database tutti i dati precedenti");
						 System.out.println(" -d --> indica la directory principale da analizzare");
						 System.out.println("       es.:  \"-d c:\\mp3\"");
						 System.out.println("       es.2: \"-d c:");
						 System.out.println();
						 return;
						}
					 else
						{System.out.println("Errore di sintassi in input -h");
						 break;
						}
					}
				}

		/* caricamento dei driver MySql e connessione al DBMS */

			 String urlsql = "jdbc:mysql://" + serverName +  "/" + mydatabase;	/* l'url JDBC */
			 try{
				String driverName = "org.gjt.mm.mysql.Driver";	/* il driver MySQL MM JDBC */
				Class.forName(driverName);
				con = DriverManager.getConnection(urlsql, username, password);	/* Connessione al DBMS */
				}
			 catch (ClassNotFoundException e) {
				System.out.println("Non c'e' il driver del database?");
				return;
				}
			 catch (Exception e) {
				System.out.println("Errore nel caricamento dei driver o nella connessione al DBMS");
				return;
				}

			 if(cancella==1)	/* Si vogliono cancellare dal DB le righe corrispondenti all'host */
				{try
					{Statement stmt = con.createStatement();
					 String sql = "delete from mp3 where nome_host='" + nome_host + "' AND ip='" + ind_ip + "'";
					 stmt.executeUpdate(sql);
					}
				 catch (SQLException e2)
					{System.out.println("SQLException: " + e2.getMessage()); 
	      				 System.out.println("SQLState: " + e2.getSQLState()); 
    					 System.out.println("VendorError: " + e2.getErrorCode()); 
					}
				 catch (Exception e2)
					{System.out.println("Errore nella cancellazione delle righe precedenti");
					 return;
					}
				}

			 if(url==null)		/* directory di scansione vuota */
				{File prog=new File("Smp3.class");	/* prendo di default la cartella corrente (in cui sto eseguendo il programma "Smp3.class") */
									/* public File(String pathname) */
			/* NOTA BENE: e' necessario modificare questa riga (ed alcune poco piu' sotto) se si cambia il nome del file */

				 url=prog.getAbsolutePath();		/* public String getAbsolutePath()
										(Returns the absolute pathname string of this abstract pathname) */
				 url=url.substring(0,url.length()-10); /* estraggo dal pathname assoluto la directory in cui mi trovo */
					/* 10 e' la lunghezza del nome "Smp3.class" (da cambiare se si rinomina il file java) */
				}
			 if(ro==null)		/* directory di condivisione vuota. Blocco di codice analogo al precedente */
				{File prog=new File("Smp3.class");
				 ro=prog.getAbsolutePath();
				 ro=ro.substring(0,ro.length()-10);	/* 10 e' la lunghezza del nome "Smp3.class" */
				}
			 System.out.println("\n\n     Cartella principale di ricerca:\n       "+url);
			 System.out.println();
			 System.out.println("     Cartella di root di condivisione:\n       "+ro+"\n");
			 System.out.println();
			 ro=correggi(ro);	/* effettua una correzione sulla stringa ro */
			 cerca(url);		/* Do' il via al programma vero e proprio */
			 
			 try{
				con.close();	/* chiudo la connessione con il DBMS */
				}
			 catch (Exception e) {
				System.out.println("Errore durante la disconnessione dal DBMS");
				}
		}



/* Questa funzione e' il programma vero e proprio.
   E' una funzione ricorsiva; memorizza (e scansiona) le cartelle e le sottocartelle
   utilizzando una struttura a pila (stack) */

	public static void cerca(String u)
		{String path="";
		 String nome="";
		 String album="";
		 String artista="";
		 String commento="";
		 String titolo="";
		 String anno="";
		 String link="";
		 String a[];		/* struttura utilizzata per la memorizzazione del contenuto delle directory */
		 String estensione=".mp3";
		 File b=new File(u);		/* crea un nuovo oggetto File che identifichi la cartella corrente */
		 a=b.list();			/* memorizza in a[] il contenuto della directory */
		 for(int i=0;i < a.length;i++)			/* scansiona la directory */
				{File c=new File(u,a[i]);
				 if(c.isDirectory())		/* se l'oggetto scansionato e' una cartella chiama ricorsivamente la funzione cerca */
					{			/* con in input il path assoluto della cartella trovata */
					 cerca(u+a[i]+java.io.File.separator);
					 continue;		/* quando ritorno a questo livello (cioe' quando ho scansionato tutte le sottocartelle) */
					}			/* vai al passo successivo del for, quindi controlla il successivo oggetto della cartella corrente */
				 if(a[i].length() < 5)		/* se l'oggetto corrente e' un file con nome piu' corto di 5 caratteri */
					continue;		/* non sara' sicuramente un file con estensione mp3 (almeno 5 caratteri: "1.mp3") */
				 if(estensione.equalsIgnoreCase(a[i].substring(a[i].length()-4)))		/* se il file ha estensione ".mp3" lo prendo in considerazione, se no passo al prossimo oggetto */
					{if(c.isFile())
						{de.vdheide.mp3.ID3 d=new ID3(c);		/* creo un nuovo oggetto ID3 */
						 nome=correggi(a[i]);				/* correggo il nome del file e il path per il passaggio a MySql */
						 path=correggi(u);
						 try
							{if(d.checkForTag())			/* estraggo e memorizzo i tag id3 */
								{album=d.getAlbum();
								 album=correggi(album);		/* e li correggo per il passaggio a MySql */
								 artista=d.getArtist();
								 artista=correggi(artista);
								 commento=d.getComment();
								 commento=correggi(commento);
								 titolo=d.getTitle();
								 titolo=correggi(titolo);
								 anno=d.getYear();
								 anno=correggi(anno);
								}
							 else					/* se i tag non sono presenti */
								{album="";
								 artista="";
								 commento="";
								 titolo="";
								 anno="";
								}
							}
						 catch (Exception ex) {
							System.out.println("Errore nel prelievo del tag id3 del file "+u+" --> "+a[i]);
							}

					/* ora devo occuparmi dei link da inserire in MySql per l'interfaccia utente */
					/* innanzi tutto se la lunghezza del path corrente e' minore della lunghezza del path di condivisione */
					/* sono sicuro che il file non sara' disponibile in linea */

						 if(path.length() < ro.length())
							{link="progetto-sebd/no.htm";
							}
						 else		/* se il path corrente e' una subdirectory del path di condivisione ricostruisco il link */
							{if(ro.equalsIgnoreCase(path.substring(0,ro.length())))		/* da notare che il programma utilizza per il confronto una funzione che ignora la differenza fra caratteri minuscoli o maiuscoli */
								{link=path.substring(ro.length());			/* quindi per esempio c:\FiLeMp3 sara' uguale a c:\fIlEmP3 */
								 link=link.concat(nome);
								 link=correggiLink(link);
								}
							 else
								{link="progetto-sebd/no.htm";
								}
							}

						 try {			/* ora ho tutte le informazioni che mi servono: inserisco quindi la riga nel DBMS */
							Statement stmt = con.createStatement();
							String sql = "INSERT INTO " + my_table + " VALUES('" + ind_ip + "','" + nome_host + "','" + nome + "','" + path + "','" + link + "','" + artista + "','" + titolo + "','" + album + "','" + anno + "','" + commento +"')";
							stmt.executeUpdate(sql);
							}
						 catch (SQLException e) {
							try{		/* se ho un errore del tipo SQLException potrebbe voler dire che la riga e' gia' presente --> provo quindi prima di tutto ad aggiornarla */
								Statement stmt = con.createStatement();
								String sql2 = "UPDATE " + my_table + " SET artista='" + artista + "',titolo='" + titolo + "',album='" + album + "',anno='" + anno + "',commento='" + commento + "',link='" + link + "' WHERE ip='" + ind_ip + "' AND nome_host='" + nome_host + "' AND nome_file='" + nome + "' AND path='" + path + "'";
								stmt.executeUpdate(sql2);
								}
							catch (SQLException e2){
							        System.out.println("SQLException: " + e2.getMessage()); 
	      						        System.out.println("SQLState: " + e2.getSQLState()); 
    							        System.out.println("VendorError: " + e2.getErrorCode()); 
								}
							catch (Exception e2){
								System.out.println("Errore nell'update della riga corrispondente al file " + path + " + " + nome);
								}
							}
						 catch (Exception e) {
							System.out.println("Errore nell'inserimento della riga corrispondente al file " + path + " + " + nome);
							}
						} /* fine if(c.isFile()) */
					} /* fine if(estensione.equals(a[i].substring(a[i].length()-3))) */
				} /* fine for(int i=0;i < a.length;i++) */
		}


/* questa funzione effettua una correzione sulla stringa in input per non avere problemi quando
   la stringa sara' passata a MySql. La correzione riguarda la barra "\" e l'apice singolo */

	public static String correggi(String a)
		{char[] data=new char[a.length()+a.length()+a.length()+a.length()];
		 int k=0;
		 String ritorno=null;
		 String barra="\\";
		 String apo="'";
		 for(int y=0;y < a.length();y++)
			{data[k]=a.charAt(y);
			 if(barra.equals(a.substring(y,y+1)))
				{k++;
				 data[k]='\\';
				}
			 if(apo.equals(a.substring(y,y+1)))
				{data[k+1]=a.charAt(y);
				 data[k]='\\';
				 k++;
				}
			 k++;
			}
		ritorno=java.lang.String.valueOf(data,0,k);
		return ritorno;
		}


/* questa funzione effettua una correzione sulla stringa che indica il collegamento al file
   perche' in windows il carattere di separazione e' "\", mentre su molti altri
   sistemi operativi e in rete e' "/" */

	public static String correggiLink(String a)
		{char[] data=new char[a.length()+a.length()];
		 int k=0;
		 String ritorno=null;
		 String barra="\\";
		 String apo="'";
		 for(int y=0;y < a.length();y++)
			{if(barra.equals(a.substring(y,y+1)))
				{if(barra.equals(a.substring(y+1,y+2)))
					{data[k]='/';
					 k++;
					 y++;
					 continue;
					}
				}
			 data[k]=a.charAt(y);
			 k++;
			}
		ritorno=java.lang.String.valueOf(data,0,k);
		return ritorno;
		}



}
